package MusicLandscape.util.formatters;

import MusicLandscape.entities.Track;

/**
 * This class represents the concept of csv-formatting of a track.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since ExerciseSheet04
 */
public class MyCSVTrackFormatter extends MyTrackFormatter {
    /**
     * Creates a CSV format of a track.
     * <p>
     * The csv representation of a track is "title","performer","writer","year","duration"; (without quotes)<br>
     * No new line is added at the end of the String!
     *
     * @param t the track to be formatted
     * @return the formatted String representing the track
     */
    @Override
    public String format(Track t) {
        return t.getTitle() +
                "," +
                t.getPerformer() +
                "," +
                t.getWriter() +
                "," +
                t.getYear() +
                "," +
                t.getDuration() +
                ";";
    }
}
